import time
import unittest
from selenium import webdriver
from webdriver_helper import get_webdriver

from pageObject.collectObject import CollectObject
from pageObject.loginObject import LoginObject
from pageObject.gImageObject import GImageObject
from ddt import ddt, file_data, data


@ddt
class TestCase(unittest.TestCase):

    @classmethod
    def setUpClass(cls) -> None:

        cls.driver = get_webdriver()
        cls.lg = LoginObject(cls.driver)
        cls.gImage = GImageObject(cls.driver)
        cls.collect = CollectObject(cls.driver)

    @classmethod
    def tearDownClass(cls) -> None:
        cls.driver.quit()

    @file_data('../data/user.yaml')
    def test_1_login(self, mobile, password):

        self.lg.login(mobile, password)

        time.sleep(2)

    @data('病毒', '癌症')
    def test_2_search(self, s):
        # search = '病毒'
        self.gImage.operation(s)
        time.sleep(2)

    def test_3_collect(self):
        self.collect.collect()
        time.sleep(2)


if __name__ == '__main__':
    unittest.main()
