import { getRoles, removeRole, insertRole, getRoleInfo, updateRoleInfo } from './service';

const Model = {
  namespace: 'role',
  state: {
    users: {
      list: [],
      pagination: {},
    },
    roleInfo: [],
  },
  effects: {
    *getRoles({ payload }, { call, put }) {
      const response = yield call(getRoles, payload);

      yield put({
        type: 'saveUser',
        payload: response.data,
      });
    },
    *deleteRole({ payload, callback }, { call }) {
      const response = yield call(removeRole, payload);
      if (response.code === 200 && callback) {
        callback(response);
      }
    },
    *addRole({ payload, callback }, { call }) {
      const response = yield call(insertRole, payload);
      if (response.code === 200 && callback) {
        callback(response);
      }
    },
    *getRoleInfo({ payload }, { call, put }) {
      const response = yield call(getRoleInfo, payload);
      yield put({
        type: 'saveRole',
        payload: response.data,
      });
    },
    *updateRoleInfo({ payload, callback }, { call }) {
      const response = yield call(updateRoleInfo, payload);
      if (response.code === 200 && callback) {
        callback(response);
      }
    },
  },
  reducers: {
    saveUser(state, action) {
      return { ...state, users: action.payload };
    },
    saveRole(state, action) {
      return { ...state, roleInfo: action.payload };
    },
  },
};
export default Model;
