import { Form, TreeSelect, Modal, Input } from 'antd';
import React from 'react';
import { connect } from 'dva';

const { SHOW_ALL } = TreeSelect;

const RoleConfigForm = props => {
  const {
    modalVisible,
    form,
    handleUpdateRole,
    handleModalVisible,
    record: { id: roleId, actionType },
  } = props;
  const editable = actionType === 'edit';
  const selectedAuths = [];

  const okHandle = () => {
    form.validateFields((err, fieldsValue) => {
      if (err) return;
      form.resetFields();
      handleUpdateRole({
        roleId,
        ...fieldsValue,
      });
    });
  };

  const onChange = value => {
    form.setFieldsValue({ authIds: value });
  };

  const mappingRoleInfoToTreeData = (roleInfo, selected) => {
    const mappedNodes = roleInfo.map(node => {
      if (node.enabled === 'T') {
        // set initial selected item
        selectedAuths.push(node.id);
      }
      return {
        key: node.id,
        value: node.id,
        title: node.name,
        children: mappingRoleInfoToTreeData(node.childs || [], selected),
      };
    });
    return mappedNodes;
  };

  const treeData = mappingRoleInfoToTreeData(props.roleInfo || [], selectedAuths);

  const treeSelectProps = {
    onChange,
    treeCheckable: true,
    showCheckedStrategy: SHOW_ALL,
    searchPlaceholder: '请选择用户权限',
    treeDefaultExpandAll: true,
    allowClear: editable,
    style: {
      width: '100%',
    },
  };

  const renderTreeNodes = data =>
    data.map(item => {
      if (item.children) {
        return (
          <TreeSelect.TreeNode
            title={item.title}
            key={item.key}
            value={item.value}
            disableCheckbox={!editable}
          >
            {renderTreeNodes(item.children)}
          </TreeSelect.TreeNode>
        );
      }
      return <TreeSelect.TreeNode key={item.key} {...item} disableCheckbox={!editable} />;
    });

  return (
    <Modal
      destroyOnClose
      title="新建规则"
      visible={modalVisible}
      onOk={okHandle}
      onCancel={() => handleModalVisible()}
      width={800}
    >
      <Form.Item
        labelCol={{
          span: 5,
        }}
        wrapperCol={{
          span: 15,
        }}
        label="角色名称"
      >
        {form.getFieldDecorator('roleName', {
          initialValue: props.record.roleName,
          rules: [
            {
              required: true,
              message: '请输入角色名称',
            },
          ],
        })(<Input placeholder="请输入" disabled />)}
      </Form.Item>
      <Form.Item
        labelCol={{
          span: 5,
        }}
        wrapperCol={{
          span: 15,
        }}
        label="用户权限"
      >
        {form.getFieldDecorator('authIds', {
          initialValue: selectedAuths,
        })(<TreeSelect {...treeSelectProps}>{renderTreeNodes(treeData)}</TreeSelect>)}
      </Form.Item>
    </Modal>
  );
};

export default connect(({ role, loading }) => ({
  roleInfo: role.roleInfo,
  loading: loading.models.role,
}))(Form.create()(RoleConfigForm));
