import request from '@/utils/request';

export async function getRoles(params) {
  return request(
    {
      method: 'post',
      url: '/rest/admin/SysSystemRole/list',
      // front end params to server end dto
      params: {
        ...params,
      },
    },
    // server end vo to front end object
    res => {
      const formattedRes = {
        ...res,
        data: {
          list: res.data.list.map(item => Object.assign(item, { key: item.id })),
          pagination: {
            current: res.data.pageNum,
            pageSize: res.data.pageSize,
            total: res.data.total,
          },
        },
      };
      return formattedRes;
    },
  );
}

export async function removeUser(params) {
  return request({
    method: 'post',
    url: '/rest/admin/MemberInfo/remove',
    params,
  });
}

export async function insertRole(params) {
  return request({
    method: 'post',
    url: '/rest/admin/SysSystemRole/insert',
    params,
  });
}

export async function removeRole(params) {
  return request({
    method: 'post',
    url: '/rest/admin/SysSystemRole/remove',
    params,
  });
}

export async function updateRole(params) {
  return request({
    method: 'post',
    url: '/rest/admin/SysSystemRole/update',
    params,
  });
}

export async function viewRole(params) {
  return request({
    method: 'post',
    url: '/rest/admin/SysSystemRole/insert',
    params,
  });
}

export async function getRoleInfo(params) {
  return request({
    method: 'post',
    url: '/rest/admin/SysSystemRole/getInfo',
    params: {
      roleId: params.id,
    },
  });
}

export async function updateRoleInfo(params) {
  const { roleId, authIds } = params;
  return request({
    method: 'post',
    url: '/rest/admin/SysSystemRole/updateInfo',
    params: {
      roleId,
      authIds,
    },
  });
}
